'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - Ultima Printers                         **/
'/**                                                                       **/
'/**  MODULE NAME  : Driver2.vb                                            **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Imports System.Runtime.InteropServices
Imports System.Drawing.Imaging

Partial Public Class Main

#Region "=== Initialisation ==="

    Private Sub InitDriver2Tab()
        InitPrintSettings()
        InitCardSettings()
        InitHoloKote()
        InitHoloKoteID()
        InitColourAdjust()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Local Methods ==="

    Private Sub Driver2Controls(Control As Boolean)
        DuplexCombo.Enabled = Control
        CardSizeCombo.Enabled = Control
        CopyCountUpDown.Enabled = Control
        ColourFormatCombo.Enabled = Control
        OrientationCombo.Enabled = Control
        Overcoat.Enabled = Control
        Rotate.Enabled = Control
        HoloKoteImageUpDown.Enabled = Control
        HoloKoteRotationCombo.Enabled = Control

        HoloKoteIDSlot.Enabled = Not Control
        HoloKoteIDButton.Enabled = Not Control

        ColourAdjust_Contrast.Enabled = Control
        ColourAdjust_Brightness.Enabled = Control
        ColourAdjust_Colour.Enabled = Control
        ColourAdjust_Tint.Enabled = Control
        ColourAdjust_Red.Enabled = Control
        ColourAdjust_Green.Enabled = Control
        ColourAdjust_Blue.Enabled = Control
        ColourAdjust_Negative.Enabled = Control
        ColourAdjust_DarkPic.Enabled = Control
        ColourAdjust_Illuminant.Enabled = Control
        ColourAdjust_BlackRef.Enabled = Control
        ColourAdjust_WhiteRef.Enabled = Control
    End Sub

    Private Function Driver2ActionIsGet() As Boolean
        Return Driver2GetRadio.Checked
    End Function

    Private Sub Driver2GetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles Driver2GetRadio.CheckedChanged
        Driver2Controls(False)
    End Sub

    Private Sub Driver2SetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles Driver2SetRadio.CheckedChanged
        Driver2Controls(True)
    End Sub

    Private Sub ClearDriver2MsgBoxButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ClearDriver2MsgBoxButton.Click
        Driver2MsgBox.Clear()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Print Settings ==="

    Private duplexkp As New Dictionary(Of SDK.Duplex, String) From
    {
        {SDK.Duplex.FrontOnly, "Front Only"},
        {SDK.Duplex.Both, "Both Sides"},
        {SDK.Duplex.BackOnly, "Back Only"}
    }

    Private cardsizekp As New Dictionary(Of Integer, String)

    Private Sub InitPrintSettings()
        DuplexCombo.DataSource = New BindingSource(duplexkp, Nothing)
        DuplexCombo.DisplayMember = "Value"
        DuplexCombo.ValueMember = "Key"
    End Sub

    Private Function GetPrintSettings(ByRef settings As SDK.PrintSetting) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_PrintSettings(hSession, SDK.Action.Read, settings)
        If SDKReturn = SDK.Return.Success Then
            SetPrintSettings(settings)
        Else
            HandleError("GetPrintSettings", SDKReturn)
        End If
        Return SDKReturn
    End Function

    Private Sub PrintSettingsToMsgBox(Action As SDK.Action, settings As SDK.PrintSetting)
        Dim sep As String = Separator(Action)
        Driver2MsgBox.AppendText("Print Settings:" + Environment.NewLine)
        Driver2MsgBox.AppendText("Duplex" + sep + duplexkp.Item(settings.Duplex) + Environment.NewLine)
        Driver2MsgBox.AppendText("Copy Count" + sep + settings.CopyCount.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Card Size" + sep + cardsizekp.Item(settings.CardSize) + Environment.NewLine)
        Driver2MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetPrintSettings(settings As SDK.PrintSetting)
        DuplexCombo.Text = duplexkp.Item(settings.Duplex)
        CopyCountUpDown.Value = settings.CopyCount
        CardSizeCombo.Text = cardsizekp.Item(settings.CardSize)
    End Sub

    Private Sub PrintSettingsButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles PrintSettingsButton.Click
        Dim settings As New SDK.PrintSetting

        If Driver2ActionIsGet() Then
            If GetPrintSettings(settings) = SDK.Return.Success Then
                PrintSettingsToMsgBox(SDK.Action.Read, settings)
            End If
        Else
            settings.Duplex = DuplexCombo.SelectedItem.Key
            settings.CopyCount = CopyCountUpDown.Value
            settings.CardSize = CardSizeCombo.SelectedItem.Key

            Dim SDKReturn As SDK.Return = SDK.ID_PrintSettings(hSession, SDK.Action.Write, settings)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetPrintSettings", SDKReturn)
            Else
                PrintSettingsToMsgBox(SDK.Action.Write, settings)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Card Settings ==="

    Private colourkp As New Dictionary(Of SDK.ColourFormat, String) From
    {
        {SDK.ColourFormat.YMC, "YMC"},
        {SDK.ColourFormat.YMCK, "YMCK"},
        {SDK.ColourFormat.K, "K-Resin"}
    }

    Private orientkp As New Dictionary(Of SDK.Orientation, String) From
    {
        {SDK.Orientation.Landscape, "Landscape"},
        {SDK.Orientation.Portrait, "Portrait"}
    }

    Private Sub InitCardSettings()
        ColourFormatCombo.DataSource = New BindingSource(colourkp, Nothing)
        ColourFormatCombo.DisplayMember = "Value"

        OrientationCombo.DataSource = New BindingSource(orientkp, Nothing)
        OrientationCombo.DisplayMember = "Value"
    End Sub

    Private Sub CardSettingsSide_Changed(sender As System.Object, e As System.EventArgs) _
                Handles CardSettingsSideCombo.SelectedIndexChanged
        If Driver2TabInit Then
            Dim CardSettings As New SDK.CardSetting
            Dim SDKReturn As SDK.Return = GetCardSettings(CardSettingsSideCombo.SelectedItem.Key, CardSettings)
            If SDKReturn = SDK.Return.Success Then
                SetCardSettings(CardSettings)
            End If
        End If
    End Sub

    Private Function GetCardSettings(side As SDK.Side, _
                                     ByRef settings As SDK.CardSetting) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_CardSettings(hSession, SDK.Action.Read, side, settings)
        If SDKReturn = SDK.Return.Success Then
            SetCardSettings(settings)
        Else
            HandleError("GetCardSettings", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub CardSettingsToMsgBox(Action As SDK.Action,
                                     side As SDK.Side,
                                     settings As SDK.CardSetting)
        Dim sep As String = Separator(Action)
        Driver2MsgBox.AppendText("Card Settings (" + sidekp.Item(side) + "):" + Environment.NewLine)
        Driver2MsgBox.AppendText("Colour Format" + sep + colourkp.Item(settings.ColourFormat) + Environment.NewLine)
        Driver2MsgBox.AppendText("Orientation" + sep + orientkp.Item(settings.Orientation) + Environment.NewLine)
        Driver2MsgBox.AppendText("Overcoat" + sep + Overcoat.Checked.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Rotate" + sep + Rotate.Checked.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetCardSettings(settings As SDK.CardSetting)
        ColourFormatCombo.Text = colourkp.Item(settings.ColourFormat)
        OrientationCombo.Text = orientkp.Item(settings.Orientation)
        Overcoat.Checked = settings.Overcoat
        Rotate.Checked = settings.Rotation
    End Sub

    Private Sub CardSettingsButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles CardSettingsButton.Click
        Dim settings As New SDK.CardSetting
        Dim side As SDK.Side = CardSettingsSideCombo.SelectedItem.Key

        If Driver2ActionIsGet() Then
            If GetCardSettings(side, settings) = SDK.Return.Success Then
                CardSettingsToMsgBox(SDK.Action.Read, side, settings)
            End If
        Else
            settings.ColourFormat = ColourFormatCombo.SelectedItem.Key
            settings.Orientation = OrientationCombo.SelectedItem.Key
            settings.Overcoat = Overcoat.Checked
            settings.Rotation = Rotate.Checked

            Dim SDKReturn As SDK.Return = SDK.ID_CardSettings(hSession, SDK.Action.Write, side, settings)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetCardSettings", SDKReturn)
            Else
                CardSettingsToMsgBox(SDK.Action.Write, side, settings)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== HoloKote Settings ==="

    Private hkrotatekp As New Dictionary(Of SDK.Rotation, String) From
    {
            {SDK.Rotation.None, "None"},
            {SDK.Rotation.Degrees_90, "90 Degrees"},
            {SDK.Rotation.Degrees_180, "180 Degrees"},
            {SDK.Rotation.Degrees_270, "270 Degrees"}
    }

    Private Sub InitHoloKote()
        HoloKoteRotationCombo.DataSource = New BindingSource(hkrotatekp, Nothing)
        HoloKoteRotationCombo.DisplayMember = "Value"
        HoloKoteRotationCombo.ValueMember = "Key"
    End Sub

    Private Sub HoloKoteSide_Changed(sender As System.Object, e As System.EventArgs) _
                Handles HoloKoteSideCombo.SelectedIndexChanged
        If Driver2TabInit Then
            Dim HoloKote As New SDK.HoloKote
            Dim SDKReturn As SDK.Return = GetHoloKote(HoloKoteSideCombo.SelectedItem.Key, HoloKote)
            If SDKReturn = SDK.Return.Success Then
                SetHoloKote(HoloKote)
            End If
        End If
    End Sub

    Private Function GetHoloKote(side As SDK.Side, _
                                 ByRef holokote As SDK.HoloKote) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_HoloKote(hSession, SDK.Action.Read, side, holokote)
        If SDKReturn = SDK.Return.Success Then
            SetHoloKote(holokote)
        Else
            HandleError("GetHoloKote", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub HoloKoteToMsgBox(Action As SDK.Action,
                                 side As SDK.Side,
                                 holokote As SDK.HoloKote)
        Dim sep As String = Separator(Action)
        Driver2MsgBox.AppendText("HoloKote (" + sidekp.Item(side) + ") " + Environment.NewLine)
        Driver2MsgBox.AppendText("Image ID" + sep + holokote.ImageID.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Map" + sep + holokote.Map.ToString("X6") + Environment.NewLine)
        Driver2MsgBox.AppendText("Rotate" + sep + hkrotatekp.Item(holokote.Rotation) + Environment.NewLine)
        Driver2MsgBox.AppendText("Use Laminate" + sep + holokote.UseLaminate.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Disable Custom Key" + sep + holokote.DisableCustomKey.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetHoloKote(holokote As SDK.HoloKote)
        HoloKoteImageUpDown.Value = holokote.ImageID
        HoloKoteRotationCombo.Text = hkrotatekp.Item(holokote.Rotation)
    End Sub

    Private Sub HoloKoteButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles HoloKoteButton.Click
        Dim holokote As New SDK.HoloKote
        Dim side As SDK.Side = HoloKoteSideCombo.SelectedItem.Key

        If Driver2ActionIsGet() Then
            If GetHoloKote(side, holokote) = SDK.Return.Success Then
                HoloKoteToMsgBox(SDK.Action.Read, side, holokote)
            End If
        Else
            holokote.ImageID = HoloKoteImageUpDown.Value
            holokote.Rotation = HoloKoteRotationCombo.SelectedItem.Key

            Dim SDKReturn As SDK.Return = SDK.ID_HoloKote(hSession, SDK.Action.Write, side, holokote)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("GetHoloKote", SDKReturn)
            Else
                HoloKoteToMsgBox(SDK.Action.Write, side, holokote)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== HoloKote ID ==="

    Private Sub InitHoloKoteID()
        HoloKoteIDSlot.SelectedIndex = 0
    End Sub

    Private Sub HoloKoteIDButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HoloKoteIDButton.Click
        Dim IDString As StringBuilder = New StringBuilder()
        Dim slotNo As Byte = HoloKoteIDSlot.SelectedIndex

        Dim SDKReturn As SDK.Return = SDK.ID_HoloKoteIdentity(hSession, slotNo, IDString)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("HoloKoteIDs", SDKReturn)
        Else
            Dim temp_string As String
            If HoloKoteIDSlot.SelectedIndex = 0 Then
                Driver2MsgBox.AppendText("HoloKote IDs: " + Environment.NewLine)

                Dim IDs() As String = IDString.ToString().Split(","c)
                Dim i As Integer = 1
                For Each identity As String In IDs
                    temp_string = i.ToString()
                    temp_string += ": "
                    temp_string += identity
                    temp_string += Environment.NewLine
                    Driver2MsgBox.AppendText(temp_string)
                    i += 1
                Next
            Else
                temp_string = "HoloKote ID "
                temp_string += HoloKoteIDSlot.SelectedIndex.ToString()
                temp_string += ": "
                temp_string += IDString.ToString()
                temp_string += Environment.NewLine
                Driver2MsgBox.AppendText(temp_string)
            End If

            Driver2MsgBox.AppendText(Environment.NewLine)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Colour Adjust Settings ==="

    Private illuminantkp As New Dictionary(Of SDK.Illuminant, String) From
    {
        {SDK.Illuminant.DEFAULT, "Default"},
        {SDK.Illuminant.A, "Tungsten Lamp"},
        {SDK.Illuminant.B, "Noon Sunlight"},
        {SDK.Illuminant.C, "NTSC Sunlight"},
        {SDK.Illuminant.D50, "Normal Print"},
        {SDK.Illuminant.D55, "Bond Paper Print"},
        {SDK.Illuminant.D65, "Standard Daylight"},
        {SDK.Illuminant.D75, "Northern Daylight"},
        {SDK.Illuminant.F2, "Cool White Lamp"}
    }

    Private Sub InitColourAdjust()
        ColourAdjust_Illuminant.DataSource = New BindingSource(illuminantkp, Nothing)
        ColourAdjust_Illuminant.DisplayMember = "Value"
        ColourAdjust_Illuminant.ValueMember = "Key"
    End Sub

    Private Sub ColourAdjToMsgBox(ByVal action As SDK.Action, ByVal ca As SDK.ColorAdjustment)
        Dim sep As String = Separator(action)
        Driver2MsgBox.AppendText("Contrast" + sep + ca.Contrast.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Brightness" + sep + ca.Brightness.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Colorfulness" + sep + ca.Colorfulness.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Red Green Tint" + sep + ca.RedGreenTint.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Red Gamma" + sep + ca.RedGamma.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Green Gamma" + sep + ca.GreenGamma.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Blue Gamma" + sep + ca.BlueGamma.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Illuminant Index" + sep + illuminantkp.Item(ca.IlluminantIndex) + Environment.NewLine)
        Driver2MsgBox.AppendText("Dark Picture" + sep)
        If ca.Flags.HasFlag(SDK.CAFlags.LogFilter) Then
            Driver2MsgBox.AppendText("On" + Environment.NewLine)
        Else
            Driver2MsgBox.AppendText("Off" + Environment.NewLine)
        End If
        Driver2MsgBox.AppendText("Negative" + sep)
        If ca.Flags.HasFlag(SDK.CAFlags.Negative) Then
            Driver2MsgBox.AppendText("On" + Environment.NewLine)
        Else
            Driver2MsgBox.AppendText("Off" + Environment.NewLine)
        End If
        Driver2MsgBox.AppendText("Reference Black" + sep + ca.ReferenceBlack.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText("Reference White" + sep + ca.ReferenceWhite.ToString() + Environment.NewLine)
        Driver2MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetColourAdjust(ByVal ca As SDK.ColorAdjustment)
        ColourAdjust_Red.Value = ca.RedGamma
        ColourAdjust_Green.Value = ca.GreenGamma
        ColourAdjust_Blue.Value = ca.BlueGamma
        ColourAdjust_BlackRef.Value = ca.ReferenceBlack
        ColourAdjust_WhiteRef.Value = ca.ReferenceWhite
        ColourAdjust_Contrast.Value = ca.Contrast
        ColourAdjust_Brightness.Value = ca.Brightness
        ColourAdjust_Colour.Value = ca.Colorfulness
        ColourAdjust_Tint.Value = ca.RedGreenTint
        ColourAdjust_Negative.Checked = ca.Flags.HasFlag(SDK.CAFlags.Negative)
        ColourAdjust_DarkPic.Checked = ca.Flags.HasFlag(SDK.CAFlags.LogFilter)
        ColourAdjust_Illuminant.Text = illuminantkp.Item(ca.IlluminantIndex)
    End Sub

    Private Function GetColourAdjust(ByRef ca As SDK.ColorAdjustment) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_ColourAdjust(hSession, SDK.Action.Read, ca)
        If SDKReturn = SDK.Return.Success Then
            SetColourAdjust(ca)
        Else
            HandleError("GetColourAdjust", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub ColourAdjustBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ColourAdjustBtn.Click
        Dim ca As New SDK.ColorAdjustment

        If Driver2ActionIsGet() Then
            If GetColourAdjust(ca) = SDK.Return.Success Then
                'Update the display
                ColourAdjToMsgBox(SDK.Action.Read, ca)
            End If

        Else
            ca.Size = Marshal.SizeOf(ca)
            ca.Contrast = Decimal.ToInt16(ColourAdjust_Contrast.Value)
            ca.Brightness = Decimal.ToInt16(ColourAdjust_Brightness.Value)
            ca.Colorfulness = Decimal.ToInt16(ColourAdjust_Colour.Value)
            ca.RedGreenTint = Decimal.ToInt16(ColourAdjust_Tint.Value)
            ca.RedGamma = Decimal.ToUInt16(ColourAdjust_Red.Value)
            ca.GreenGamma = Decimal.ToUInt16(ColourAdjust_Green.Value)
            ca.BlueGamma = Decimal.ToUInt16(ColourAdjust_Blue.Value)
            ca.Flags = 0
            If ColourAdjust_Negative.Checked Then ca.Flags = ca.Flags Or SDK.CAFlags.Negative
            If ColourAdjust_DarkPic.Checked Then ca.Flags = ca.Flags Or SDK.CAFlags.LogFilter
            ca.IlluminantIndex = ColourAdjust_Illuminant.SelectedItem.Key
            ca.ReferenceBlack = Decimal.ToUInt16(ColourAdjust_BlackRef.Value)
            ca.ReferenceWhite = Decimal.ToUInt16(ColourAdjust_WhiteRef.Value)

            'Call the SDK to write to the driver
            Dim SDKReturn As SDK.Return = SDK.ID_ColourAdjust(hSession, SDK.Action.Write, ca)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetColourAdjust", SDKReturn)
            Else
                ColourAdjToMsgBox(SDK.Action.Write, ca)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== HoloKote Preview ==="

    Private Sub HoloKotePreviewButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HoloKotePreviewButton.Click
        Cursor.Current = Cursors.WaitCursor

        Dim maxHoloKotes As Integer = SDK.ID_HoloKoteCount(hSession)
        Dim buff(maxHoloKotes) As Bitmap
        For i As Integer = 0 To maxHoloKotes - 1
            buff(i) = New Bitmap(SDK.PreviewWidth, SDK.PreviewHeight, PixelFormat.Format1bppIndexed)
        Next i

        Dim SDKReturn As SDK.Return = SDK.ID_HoloKotePreview(hSession, buff)

        If SDKReturn <> SDK.Return.Success Then
            HandleError("HolokotePreview", SDKReturn)
        Else
            Dim preview As New HKPreview(buff, maxHoloKotes)
            preview.Show()
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

End Class